/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.bmtr.core;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMException
extends RuntimeException {
    private static final long serialVersionUID = -8581611883691404427L;

    public ASMException(String message) {
        super("MaxPotionIDExtender - Class transformation error\n" + message);
    }

    public ASMException(String message, ClassNode node) {
        this(message + "\n" + ASMException.getStringDescriptor(node));
    }

    public ASMException(String message, MethodNode node) {
        this(message + "\n" + ASMException.getStringDescriptor(node));
    }

    private static String getStringDescriptor(MethodNode node) {
        StringBuilder sb = new StringBuilder();
        for (AbstractInsnNode n : node.instructions) {
            sb.append("[" + n.getOpcode() + "]\t" + ASMException.getInsnDesc(n) + "\n");
        }
        return sb.toString();
    }

    private static String getInsnDesc(AbstractInsnNode n) {
        if (n instanceof LdcInsnNode) {
            return "LDC\t" + ((LdcInsnNode)n).cst.toString();
        }
        if (n instanceof LabelNode) {
            return "Label\t" + ((LabelNode)n).getLabel().toString();
        }
        if (n instanceof LineNumberNode) {
            return "Line\t" + ((LineNumberNode)n).line;
        }
        if (n instanceof IntInsnNode) {
            if (n.getOpcode() == 188) {
                return "New primitive array";
            }
            if (n.getOpcode() == 189) {
                return "New object array";
            }
            return "Int\t" + ((IntInsnNode)n).operand;
        }
        if (n instanceof MethodInsnNode) {
            MethodInsnNode m = (MethodInsnNode)n;
            return "Method\t" + m.name + ", " + m.desc + ", " + m.owner;
        }
        if (n instanceof FieldInsnNode) {
            FieldInsnNode f = (FieldInsnNode)n;
            return "Field\t" + f.name + ", " + f.desc;
        }
        if (n instanceof InsnNode) {
            if (n.getOpcode() == 3) {
                return "C-Int 0";
            }
            if (n.getOpcode() == 4) {
                return "C-Int 1";
            }
            if (n.getOpcode() == 5) {
                return "C-Int 2";
            }
            if (n.getOpcode() == 6) {
                return "C-Int 3";
            }
            if (n.getOpcode() == 7) {
                return "C-Int 4";
            }
            if (n.getOpcode() == 8) {
                return "C-Int 5";
            }
            if (n.getOpcode() == 89) {
                return "DUP";
            }
            if (n.getOpcode() == 79) {
                return "Store int in array";
            }
        }
        return n.getClass().getName();
    }

    private static String getStringDescriptor(ClassNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append("Methods:\n");
        node.methods.forEach(m -> sb.append(m.name + ": " + m.desc + "\n"));
        sb.append("Fields:\n");
        node.fields.forEach(f -> sb.append(f.name + ": " + f.desc + "\n"));
        return sb.toString();
    }
}

